<?php

	/*Database Connection*/
	include("dbconnection.php");

	//Include the main TCPDF library.
	require 'tcpdf/vendor/autoload.php';

	//create new PDF document
	$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	//set header and footer fonts
	$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
	$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

	//set default monospaced font
	$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

	//set margins
	//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetMargins(PDF_MARGIN_LEFT, 10, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

	//set header footer true/false
	$pdf->SetPrintHeader(false);
	$pdf->SetPrintFooter(true);

	//set image scale factor
	$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

	//set some language-dependent strings (optional)
	if (@file_exists(dirname(__FILE__).'/tcpdf/lang/eng.php')) {
		require_once(dirname(__FILE__).'/tcpdf/lang/eng.php');
		$pdf->setLanguageArray($l);
	}

	//set font
	$pdf->SetFont('dejavusans', '', 10);

	//add a page
	$pdf->AddPage();

	/*sql*/
	$sql = "SELECT id, ItemName, ItemCode,`Date`, Price, Quantity 
	FROM excelexport ORDER BY ItemName;";
	$result = $pdo->query($sql);
	$dataList = '';
	$i=1; 
	while ($aRow = $result->fetch(PDO::FETCH_ASSOC)){
		$dataList .= '<tr> 
			<td class="txt-center" style="width:5%;">'.$i++.'</td> 
			<td style="width:35%;">'.$aRow['ItemName'].'</td> 
			<td style="width:15%;">'.$aRow['ItemCode'].'</td> 
			<td style="width:15%;">'.$aRow['Date'].'</td> 
			<td class="txt-right" style="width:15%;">'.number_format($aRow['Price'],2).'</td> 
			<td class="txt-right" style="width:15%;">'.number_format($aRow['Quantity']).'</td>
		</tr>';
	}

	$html ='<style>
		h3 {
			font-size: 18px;
			text-align:center;
		}
		table td, table th {
			border: 1px solid #000;
		}
		.txt-right {
			text-align:right;
		}	
		.txt-left {
			text-align:left;
		}	
		.txt-center {
			text-align:center;
		}
	</style>
	
	<!--header-->
	<h3>Basic</h3>
	<!--html table -->
	<table width="100%" cellpadding="3" cellspacing="0">
		<thead> 
			<tr>
				<th class="txt-center" style="width:5%;"><strong>#</strong></th>
				<th style="width:35%;"><strong>Item Name</strong></th> 
				<th style="width:15%;"><strong>Item Code</strong></th> 
				<th style="width:15%;"><strong>Date</strong></th> 
				<th class="txt-right" style="width:15%;"><strong>Price</strong></th> 
				<th class="txt-right" style="width:15%;"><strong>Quantity</strong></th> 
			</tr> 
		</thead> 
		<tbody>
		'.$dataList.'	
		</tbody> 
	</table>';

	//output the HTML content
	$pdf->writeHTML($html, true, false, true, false, '');

	//reset pointer to the last page
	$pdf->lastPage();

	$exportTime = date("Y-m-d-His", time());
	$file = 'basic-'.$exportTime. '.pdf'; //Save file name
	$pdf->Output(dirname(__FILE__).'/media/'.$file, 'F');
	header('Location:media/' . $file); //File open location

?>